/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.effects;

import org.eclipse.swt.*;

import intrinsic.flash.filters.*;

public class BlurEffect extends Effect {
	
	public BlurEffect() {
		super();
	}
	
	void createHandle() {
		BlurFilter filter = new BlurFilter();
		if (filter == null) SWT.error(SWT.ERROR_NO_HANDLES);
		object = filter;
	}
	
	public void setRadius(double radius) {
		checkEffect();
		BlurFilter filter = (BlurFilter)object;
		filter.blurX = filter.blurY = radius;
	}
}
